<?php

/**
 * BasePerformanceReview
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property integer $statusId
 * @property integer $employeeNumber
 * @property date $workPeriodStart
 * @property date $workPeriodEnd
 * @property integer $jobTitleCode
 * @property integer $departmentId
 * @property date $dueDate
 * @property date $completedDate
 * @property timestamp $activatedDate
 * @property clob $finalComment
 * @property decimal $finalRate
 * @property Doctrine_Collection $reviewerRating
 * @property Doctrine_Collection $reviewers
 * @property JobTitle $JobTitle
 * @property Subunit $Department
 * @property Employee $Employee
 * 
 * @method integer             getId()              Returns the current record's "id" value
 * @method integer             getStatusId()        Returns the current record's "statusId" value
 * @method integer             getEmployeeNumber()  Returns the current record's "employeeNumber" value
 * @method date                getWorkPeriodStart() Returns the current record's "workPeriodStart" value
 * @method date                getWorkPeriodEnd()   Returns the current record's "workPeriodEnd" value
 * @method integer             getJobTitleCode()    Returns the current record's "jobTitleCode" value
 * @method integer             getDepartmentId()    Returns the current record's "departmentId" value
 * @method date                getDueDate()         Returns the current record's "dueDate" value
 * @method date                getCompletedDate()   Returns the current record's "completedDate" value
 * @method timestamp           getActivatedDate()   Returns the current record's "activatedDate" value
 * @method clob                getFinalComment()    Returns the current record's "finalComment" value
 * @method decimal             getFinalRate()       Returns the current record's "finalRate" value
 * @method Doctrine_Collection getReviewerRating()  Returns the current record's "reviewerRating" collection
 * @method Doctrine_Collection getReviewers()       Returns the current record's "reviewers" collection
 * @method JobTitle            getJobTitle()        Returns the current record's "JobTitle" value
 * @method Subunit             getDepartment()      Returns the current record's "Department" value
 * @method Employee            getEmployee()        Returns the current record's "Employee" value
 * @method PerformanceReview   setId()              Sets the current record's "id" value
 * @method PerformanceReview   setStatusId()        Sets the current record's "statusId" value
 * @method PerformanceReview   setEmployeeNumber()  Sets the current record's "employeeNumber" value
 * @method PerformanceReview   setWorkPeriodStart() Sets the current record's "workPeriodStart" value
 * @method PerformanceReview   setWorkPeriodEnd()   Sets the current record's "workPeriodEnd" value
 * @method PerformanceReview   setJobTitleCode()    Sets the current record's "jobTitleCode" value
 * @method PerformanceReview   setDepartmentId()    Sets the current record's "departmentId" value
 * @method PerformanceReview   setDueDate()         Sets the current record's "dueDate" value
 * @method PerformanceReview   setCompletedDate()   Sets the current record's "completedDate" value
 * @method PerformanceReview   setActivatedDate()   Sets the current record's "activatedDate" value
 * @method PerformanceReview   setFinalComment()    Sets the current record's "finalComment" value
 * @method PerformanceReview   setFinalRate()       Sets the current record's "finalRate" value
 * @method PerformanceReview   setReviewerRating()  Sets the current record's "reviewerRating" collection
 * @method PerformanceReview   setReviewers()       Sets the current record's "reviewers" collection
 * @method PerformanceReview   setJobTitle()        Sets the current record's "JobTitle" value
 * @method PerformanceReview   setDepartment()      Sets the current record's "Department" value
 * @method PerformanceReview   setEmployee()        Sets the current record's "Employee" value
 * 
 * @package    orangehrm
 * @subpackage model\performance\base
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BasePerformanceReview extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_performance_review');
        $this->hasColumn('id', 'integer', 6, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 6,
             ));
        $this->hasColumn('status_id as statusId', 'integer', 11, array(
             'type' => 'integer',
             'length' => 11,
             ));
        $this->hasColumn('employee_number as employeeNumber', 'integer', 11, array(
             'type' => 'integer',
             'length' => 11,
             ));
        $this->hasColumn('work_period_start as workPeriodStart', 'date', null, array(
             'type' => 'date',
             ));
        $this->hasColumn('work_period_end as workPeriodEnd', 'date', null, array(
             'type' => 'date',
             ));
        $this->hasColumn('job_title_code as jobTitleCode', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('department_id as departmentId', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('due_date as dueDate', 'date', null, array(
             'type' => 'date',
             ));
        $this->hasColumn('completed_date as completedDate', 'date', null, array(
             'type' => 'date',
             ));
        $this->hasColumn('activated_date as activatedDate', 'timestamp', 25, array(
             'type' => 'timestamp',
             'length' => 25,
             ));
        $this->hasColumn('final_comment as finalComment', 'clob', 65532, array(
             'type' => 'clob',
             'length' => 65532,
             ));
        $this->hasColumn('final_rate as finalRate', 'decimal', null, array(
             'type' => 'decimal',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('ReviewerRating as reviewerRating', array(
             'local' => 'id',
             'foreign' => 'review_id'));

        $this->hasMany('Reviewer as reviewers', array(
             'local' => 'id',
             'foreign' => 'review_id'));

        $this->hasOne('JobTitle', array(
             'local' => 'jobTitleCode',
             'foreign' => 'id'));

        $this->hasOne('Subunit as Department', array(
             'local' => 'departmentId',
             'foreign' => 'id'));

        $this->hasOne('Employee', array(
             'local' => 'employee_number',
             'foreign' => 'emp_number'));
    }
}