<?php

/**
 * BaseOpenidProvider
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $providerId
 * @property string $providerName
 * @property string $providerUrl
 * @property integer $status
 * @property Doctrine_Collection $UserIdentitiy
 * @property AuthProviderExtraDetails $AuthProviderExtraDetails
 * 
 * @method integer                  getProviderId()               Returns the current record's "providerId" value
 * @method string                   getProviderName()             Returns the current record's "providerName" value
 * @method string                   getProviderUrl()              Returns the current record's "providerUrl" value
 * @method integer                  getStatus()                   Returns the current record's "status" value
 * @method Doctrine_Collection      getUserIdentitiy()            Returns the current record's "UserIdentitiy" collection
 * @method AuthProviderExtraDetails getAuthProviderExtraDetails() Returns the current record's "AuthProviderExtraDetails" value
 * @method OpenidProvider           setProviderId()               Sets the current record's "providerId" value
 * @method OpenidProvider           setProviderName()             Sets the current record's "providerName" value
 * @method OpenidProvider           setProviderUrl()              Sets the current record's "providerUrl" value
 * @method OpenidProvider           setStatus()                   Sets the current record's "status" value
 * @method OpenidProvider           setUserIdentitiy()            Sets the current record's "UserIdentitiy" collection
 * @method OpenidProvider           setAuthProviderExtraDetails() Sets the current record's "AuthProviderExtraDetails" value
 * 
 * @package    orangehrm
 * @subpackage model\openidauthentication\base
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseOpenidProvider extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_openid_provider');
        $this->hasColumn('id as providerId', 'integer', null, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             ));
        $this->hasColumn('provider_name as providerName', 'string', 40, array(
             'type' => 'string',
             'length' => 40,
             ));
        $this->hasColumn('provider_url as providerUrl', 'string', 250, array(
             'type' => 'string',
             'length' => 250,
             ));
        $this->hasColumn('status', 'integer', null, array(
             'type' => 'integer',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('UserIdentitiy', array(
             'local' => 'id',
             'foreign' => 'provider_id'));

        $this->hasOne('AuthProviderExtraDetails', array(
             'local' => 'id',
             'foreign' => 'provider_id'));
    }
}