<?php

/**
 * BaseJobTitle
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property string $jobTitleName
 * @property string $jobDescription
 * @property string $note
 * @property integer $isDeleted
 * @property JobSpecificationAttachment $JobSpecificationAttachment
 * @property Doctrine_Collection $employees
 * @property Doctrine_Collection $Kpi
 * @property Doctrine_Collection $PerformanceReview
 * @property Doctrine_Collection $JobVacancy
 * 
 * @method integer                    getId()                         Returns the current record's "id" value
 * @method string                     getJobTitleName()               Returns the current record's "jobTitleName" value
 * @method string                     getJobDescription()             Returns the current record's "jobDescription" value
 * @method string                     getNote()                       Returns the current record's "note" value
 * @method integer                    getIsDeleted()                  Returns the current record's "isDeleted" value
 * @method JobSpecificationAttachment getJobSpecificationAttachment() Returns the current record's "JobSpecificationAttachment" value
 * @method Doctrine_Collection        getEmployees()                  Returns the current record's "employees" collection
 * @method Doctrine_Collection        getKpi()                        Returns the current record's "Kpi" collection
 * @method Doctrine_Collection        getPerformanceReview()          Returns the current record's "PerformanceReview" collection
 * @method Doctrine_Collection        getJobVacancy()                 Returns the current record's "JobVacancy" collection
 * @method JobTitle                   setId()                         Sets the current record's "id" value
 * @method JobTitle                   setJobTitleName()               Sets the current record's "jobTitleName" value
 * @method JobTitle                   setJobDescription()             Sets the current record's "jobDescription" value
 * @method JobTitle                   setNote()                       Sets the current record's "note" value
 * @method JobTitle                   setIsDeleted()                  Sets the current record's "isDeleted" value
 * @method JobTitle                   setJobSpecificationAttachment() Sets the current record's "JobSpecificationAttachment" value
 * @method JobTitle                   setEmployees()                  Sets the current record's "employees" collection
 * @method JobTitle                   setKpi()                        Sets the current record's "Kpi" collection
 * @method JobTitle                   setPerformanceReview()          Sets the current record's "PerformanceReview" collection
 * @method JobTitle                   setJobVacancy()                 Sets the current record's "JobVacancy" collection
 * 
 * @package    orangehrm
 * @subpackage model\admin\base
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseJobTitle extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_job_title');
        $this->hasColumn('id', 'integer', 13, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 13,
             ));
        $this->hasColumn('job_title as jobTitleName', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('job_description as jobDescription', 'string', 400, array(
             'type' => 'string',
             'length' => 400,
             ));
        $this->hasColumn('note', 'string', 400, array(
             'type' => 'string',
             'length' => 400,
             ));
        $this->hasColumn('is_deleted as isDeleted', 'integer', 1, array(
             'type' => 'integer',
             'default' => '0',
             'length' => 1,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('JobSpecificationAttachment', array(
             'local' => 'id',
             'foreign' => 'jobTitleId'));

        $this->hasMany('Employee as employees', array(
             'local' => 'id',
             'foreign' => 'job_title_code'));

        $this->hasMany('Kpi', array(
             'local' => 'id',
             'foreign' => 'jobTitleCode'));

        $this->hasMany('PerformanceReview', array(
             'local' => 'id',
             'foreign' => 'jobTitleCode'));

        $this->hasMany('JobVacancy', array(
             'local' => 'id',
             'foreign' => 'jobTitleCode'));
    }
}